/*
 * Decompiled with CFR 0.152.
 */
package mod.chiselsandbits.block;

import com.google.common.collect.Lists;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import mod.chiselsandbits.api.block.bitbag.IBitBagAcceptingBlock;
import mod.chiselsandbits.api.blockinformation.BlockInformation;
import mod.chiselsandbits.api.inventory.bit.IBitInventory;
import mod.chiselsandbits.api.inventory.management.IBitInventoryManager;
import mod.chiselsandbits.api.multistate.StateEntrySize;
import mod.chiselsandbits.block.entities.BitStorageBlockEntity;
import mod.chiselsandbits.item.BitBagItem;
import mod.chiselsandbits.registrars.ModItems;
import net.minecraft.class_1268;
import net.minecraft.class_1269;
import net.minecraft.class_1657;
import net.minecraft.class_1750;
import net.minecraft.class_1799;
import net.minecraft.class_181;
import net.minecraft.class_1922;
import net.minecraft.class_1935;
import net.minecraft.class_1937;
import net.minecraft.class_2248;
import net.minecraft.class_2338;
import net.minecraft.class_2343;
import net.minecraft.class_2350;
import net.minecraft.class_2383;
import net.minecraft.class_2520;
import net.minecraft.class_2586;
import net.minecraft.class_2680;
import net.minecraft.class_2689;
import net.minecraft.class_2769;
import net.minecraft.class_3965;
import net.minecraft.class_47;
import net.minecraft.class_4970;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class BitStorageBlock
extends class_2248
implements class_2343,
IBitBagAcceptingBlock {
    public static final class_2769<class_2350> FACING = class_2383.field_11177;

    public BitStorageBlock(class_4970.class_2251 properties) {
        super(properties);
    }

    @Nullable
    public class_2680 method_9605(class_1750 context) {
        return (class_2680)this.method_9564().method_11657(FACING, (Comparable)context.method_8042());
    }

    protected void method_9515(class_2689.class_2690<class_2248, class_2680> builder) {
        builder.method_11667(new class_2769[]{FACING});
    }

    @Nullable
    public class_2586 method_10123(@NotNull class_2338 pos, @NotNull class_2680 state) {
        return new BitStorageBlockEntity(pos, state);
    }

    @NotNull
    public class_1269 method_9534(@NotNull class_2680 state, class_1937 worldIn, @NotNull class_2338 pos, @NotNull class_1657 player, @NotNull class_1268 handIn, @NotNull class_3965 hit) {
        class_2586 tileEntity = worldIn.method_8321(pos);
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return class_1269.field_5814;
        }
        BitStorageBlockEntity tank = (BitStorageBlockEntity)tileEntity;
        class_1799 current = player.method_31548().method_7391();
        if (current.method_7909() instanceof BitBagItem) {
            return class_1269.field_5811;
        }
        if (!current.method_7960() ? tank.addHeldBits(current, player) : tank.addAllPossibleBits(player)) {
            return class_1269.field_5812;
        }
        if (tank.extractBits(player)) {
            return class_1269.field_5812;
        }
        return class_1269.field_5814;
    }

    public float method_9575(@NotNull class_2680 state, @NotNull class_1922 worldIn, @NotNull class_2338 pos) {
        return 1.0f;
    }

    public boolean method_9579(@NotNull class_2680 state, @NotNull class_1922 reader, @NotNull class_2338 pos) {
        return true;
    }

    @NotNull
    public class_1799 method_9574(class_1922 blockGetter, @NotNull class_2338 blockPos, @NotNull class_2680 state) {
        class_2586 class_25862 = blockGetter.method_8321(blockPos);
        if (!(class_25862 instanceof BitStorageBlockEntity)) {
            return super.method_9574(blockGetter, blockPos, state);
        }
        BitStorageBlockEntity bitStorageBlockEntity = (BitStorageBlockEntity)class_25862;
        return this.getTankDrop(bitStorageBlockEntity);
    }

    @NotNull
    public List<class_1799> method_9560(@NotNull class_2680 state, class_47.class_48 builder) {
        if (builder.method_305(class_181.field_1228) == null) {
            return Lists.newArrayList();
        }
        return Lists.newArrayList((Object[])new class_1799[]{this.getTankDrop((BitStorageBlockEntity)Objects.requireNonNull((class_2586)builder.method_305(class_181.field_1228)))});
    }

    public class_1799 getTankDrop(BitStorageBlockEntity bitTank) {
        class_1799 tankStack = new class_1799((class_1935)ModItems.ITEM_BIT_STORAGE.get());
        if (bitTank.getContainedBlockInformation() != null && !bitTank.getContainedBlockInformation().isAir()) {
            tankStack.method_7948().method_10566("block_information", (class_2520)bitTank.getContainedBlockInformation().serializeNBT());
            tankStack.method_7948().method_10569("count", bitTank.getBits());
        }
        return tankStack;
    }

    @Override
    public void onBitBagInteraction(class_1799 bitBagStack, class_1657 player, class_3965 blockRayTraceResult) {
        Optional<BlockInformation> toExtractCandidate;
        class_2586 tileEntity = player.field_6002.method_8321(blockRayTraceResult.method_17777());
        if (!(tileEntity instanceof BitStorageBlockEntity)) {
            return;
        }
        BitStorageBlockEntity storage = (BitStorageBlockEntity)tileEntity;
        IBitInventory bitInventory = IBitInventoryManager.getInstance().create(bitBagStack);
        BlockInformation containedState = storage.getContainedBlockInformation();
        if (player.method_18276() && containedState != null) {
            int maxAmountToInsert = bitInventory.getMaxInsertAmount(containedState);
            int bitCountToInsert = Math.min(storage.getBits(), maxAmountToInsert);
            storage.extractBits(bitCountToInsert);
            bitInventory.insert(containedState, bitCountToInsert);
        } else if (containedState != null && storage.getBits() != 0) {
            int maxAmountToInsert = StateEntrySize.current().getBitsPerBlock() - storage.getBits();
            int bitCountToInsert = Math.min(bitInventory.getMaxExtractAmount(containedState), maxAmountToInsert);
            storage.insertBits(bitCountToInsert, containedState);
            bitInventory.extract(containedState, bitCountToInsert);
        } else if (!player.method_18276() && (toExtractCandidate = bitInventory.getContainedStates().entrySet().stream().max(Map.Entry.comparingByValue()).map(Map.Entry::getKey)).isPresent()) {
            BlockInformation toExtractState = toExtractCandidate.get();
            int maxAmountToInsert = StateEntrySize.current().getBitsPerBlock();
            int bitCountToInsert = Math.min(bitInventory.getMaxExtractAmount(toExtractState), maxAmountToInsert);
            storage.insertBits(bitCountToInsert, toExtractState);
            bitInventory.extract(toExtractState, bitCountToInsert);
        }
    }
}

